#include "resource.h"
#include "glock3.hpp"

#define DT_MULT 1.5 //For the RD_DT_SCROLL control
extern HWND main_hwnd;  //My main window, need for menu.
extern HWND hDlgParam;
extern HWND hDlgRand;
extern Frame main_frame;
extern GosperClock *glock; //The object I'm editing with this dialog.

int rflag = RAND_COUNT | RAND_COLOR | RAND_LENGTH;
HWND hCurveCombo; //Combo box ID used in RandDialogProc and showparams.

static void showparams(HWND hDlg); /* This is static to this module because
	I'll have	functions with the same names in other dialog code modules. */

BOOL CALLBACK RandDialogProc( HWND hDlg, UINT message, WPARAM wParam,
	LPARAM lParam )
{ /* Note that this looks just like WndProc.  A modeless dialog
	proc must return TRUE when it processes a message and return
	FALSE for all other messages */
	int comboint;
	static HWND hCountScroll; //Used to check if WM_VSCROLL is for here.
	static HWND hDtScroll; //Used to check if WM_VSCROLL is for here.

	wParam = (int)LOWORD(wParam); //Need to do this for 32 bit.
	switch (message)
	{ //Normally these are the only messages you need process.
		case WM_INITDIALOG:
			CheckMenuItem( GetMenu(main_hwnd), IDM_RAND,
				MF_BYCOMMAND | MF_CHECKED );
			hCurveCombo = GetDlgItem(hDlg, RD_GOSPER_CURVE);
			hCountScroll = GetDlgItem(hDlg, RD_HAND_COUNT_SCROLL);
			hDtScroll = GetDlgItem(hDlg, RD_DT_SCROLL);
			/*Note that you must be sure that the default "Sort" Style checkbox
			is turned off in the Resource Editor when you make this combo box,
			otherwise the items will appear sorted alphabeticaly and won't
			match the order of the GC_??? ID codes */
			SendMessage( hCurveCombo, CB_ADDSTRING, 0, (LONG)"Line");
			SendMessage( hCurveCombo, CB_ADDSTRING, 1, (LONG)"Smooth Triangle");
			SendMessage( hCurveCombo, CB_ADDSTRING, 2, (LONG)"Triangle");
			SendMessage( hCurveCombo, CB_ADDSTRING, 3, (LONG)"Square");
			SendMessage( hCurveCombo, CB_ADDSTRING, 4, (LONG)"Pentagon");
			SendMessage( hCurveCombo, CB_ADDSTRING, 5, (LONG)"Seven-Gon");
			SendMessage( hCurveCombo, CB_ADDSTRING, 6, (LONG)"Twelve-Gon");
			showparams(hDlg);
			return TRUE;
		case WM_VSCROLL:
			if ((HWND)lParam == hCountScroll)
			{
				switch (wParam)
				{
					case SB_LINEUP:
						if (!glock->ChangeHandCount(1))
						{
							MessageBeep(0);
							break;
						}
						glock->SetRadius(main_frame);
						if (hDlgParam)
							SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
						break;
					case SB_LINEDOWN:
						if (!glock->ChangeHandCount(-1))
						{
							MessageBeep(0);
							break;
						}
						glock->SetRadius(main_frame);
						if (hDlgParam)
							SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
						break;
				}
				return TRUE;
			}
			else if ((HWND)lParam == hDtScroll)
			{
				switch (wParam)
				{
					case SB_LINEUP: //Higher speed means bigger DT
						glock->SetDt(glock->dt() * DT_MULT);
						if (hDlgParam)
							SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
						break;
					case SB_LINEDOWN: //Smaller speed means smaller DT
						glock->SetDt(glock->dt() / DT_MULT);
						if (hDlgParam)
							SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
						break;
				}
				return TRUE;
			}
			else
				return FALSE; //Not a scrolbar in this dialog
		case WM_COMMAND:
			switch(wParam)
			{
				case RD_COUNT:
					rflag ^= RAND_COUNT;
					break;
				case RD_LENGTH:
					rflag ^= RAND_LENGTH;
					break;
				case RD_PHASE:
					rflag ^= RAND_PHASE;
					break;
				case RD_RATE:
					rflag ^= RAND_RATE;
					break;
				case RD_COLOR:
					rflag ^= RAND_COLOR;
					break;
				case RD_RANDOMIZE:
					glock->Randomize(rflag);
					glock->SetRadius(main_frame);
					if (hDlgParam)
						SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
					break;
				case RD_PERMUTE:
					glock->Permute(); //calls Reset().
					if (hDlgParam)
						SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
					break;
			  	case RD_GOSPER_CURVE:
					comboint = SendMessage((HWND)hCurveCombo, CB_GETCURSEL, 0, 0L); 
					glock->SetGosperCurve(comboint);
					glock->SetRadius(main_frame);
					if (hDlgParam)
						SendMessage(hDlgParam, WM_COMMAND, PD_UPDATE, 0L);
					break;
				default:
					break;
			}
			showparams(hDlg);
			return TRUE;
		case WM_CLOSE: //This can be generated in various ways.
			DestroyWindow(hDlg);
			return TRUE;
		case WM_DESTROY: //
			CheckMenuItem( GetMenu(main_hwnd), IDM_RAND,
				MF_BYCOMMAND | MF_UNCHECKED );
			hDlgRand = NULL;
			InvalidateRect( main_hwnd, NULL, TRUE );
			return TRUE;
		default:
			return FALSE;
	}
}

static void showparams(HWND hDlg)
{//Display current values based on your glock accessors.
	CheckDlgButton( hDlg, RD_COUNT,
		rflag&RAND_COUNT?MF_CHECKED:MF_UNCHECKED);
	CheckDlgButton( hDlg, RD_LENGTH,
		rflag&RAND_LENGTH?MF_CHECKED:MF_UNCHECKED);
	CheckDlgButton( hDlg, RD_PHASE,
		rflag&RAND_PHASE?MF_CHECKED:MF_UNCHECKED);
	CheckDlgButton( hDlg, RD_RATE,
		rflag&RAND_RATE?MF_CHECKED:MF_UNCHECKED);
	CheckDlgButton( hDlg, RD_COLOR,
		rflag&RAND_COLOR?MF_CHECKED:MF_UNCHECKED);
	if (!SendMessage(hCurveCombo, CB_GETDROPPEDSTATE, 0, 0L))
		SendMessage(hCurveCombo, CB_SETCURSEL, (WORD)glock->gosper_curve(), 0);
}


